/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.entity.Dog;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.packet.data.DogExplosionData;
import doggytalents.common.talent.OokamiKazeTalent;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class DogExplosionPacket
implements IPacket<DogExplosionData> {
    @Override
    public void encode(DogExplosionData data, FriendlyByteBuf buf) {
        buf.writeInt(data.dogId);
        boolean has_knockback = data.knockback().isPresent();
        buf.writeBoolean(has_knockback);
        if (has_knockback) {
            Vec3 knock = data.knockback().get();
            buf.writeDouble(knock.m_7096_());
            buf.writeDouble(knock.m_7098_());
            buf.writeDouble(knock.m_7094_());
        }
    }

    @Override
    public DogExplosionData decode(FriendlyByteBuf buf) {
        int id = buf.readInt();
        boolean has_knockback = buf.readBoolean();
        Vec3 knock = null;
        if (has_knockback) {
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            knock = new Vec3(x, y, z);
        }
        return new DogExplosionData(id, knock);
    }

    @Override
    public void handle(DogExplosionData data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                Minecraft mc = Minecraft.m_91087_();
                Entity e = mc.f_91073_.m_6815_(data.dogId);
                if (e instanceof Dog) {
                    Dog dog = (Dog)e;
                    OokamiKazeTalent.explodeClient(dog);
                    data.knockback().ifPresent(x -> {
                        LocalPlayer player = mc.f_91074_;
                        if (player == null) {
                            return;
                        }
                        Vec3 knock_movement = player.m_20184_().m_82549_(x);
                        player.m_20256_(knock_movement);
                    });
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

